// linkList.java
// demonstruje dziaanie listy powizanej
// uruchomienie programu: C>java LinkListApp
////////////////////////////////////////////////////////////////
class Link
   {
   public int iData;              // dane
   public double dData;           // dane
   public Link next;              // referencja do nastpnego poczenia
// -------------------------------------------------------------
   public Link(int id, double dd) // konstruktor
      {
      iData = id;                 // inicjalizacja danych
      dData = dd;                 // (pole next ma automatycznie warto null)
      }
// -------------------------------------------------------------
   public void displayLink()      // wypisuje warto pl
      {
      System.out.print("{" + iData + ", " + dData + "} ");
      }
   }  // koniec klasy Link
////////////////////////////////////////////////////////////////
class LinkList
   {
   private Link first;            // referencja do pierwszego elementu listy

// -------------------------------------------------------------
   public LinkList()              // konstruktor
      {
      first = null;               // lista nie ma jeszcze elementw
      }
// -------------------------------------------------------------
   public boolean isEmpty()       // zwraca true, jeeli lista jest pusta
      {
      return (first==null);
      }
// -------------------------------------------------------------
                                  // wstawienie na pocztek listy
   public void insertFirst(int id, double dd)
      {                           // tworzymy nowe poczenie
      Link newLink = new Link(id, dd);
      newLink.next = first;       // newLink --> dotychczasowy pierwszy element
      first = newLink;            // first --> newLink
      }
// -------------------------------------------------------------
   public Link deleteFirst()      // usuwanie pierwszego elementu
      {                           // (zakadamy, e lista nie jest pusta)
      Link temp = first;          // zapisujemy referencj do pierwszego elementu
      first = first.next;         // usuwamy go z listy: first-->poprzednio drugi
      return temp;                // zwracamy usunity element
      }
// -------------------------------------------------------------
   public void displayList()
      {
      System.out.print("Lista (pocztek-->koniec): ");
      Link current = first;       // zaczynamy na pocztku listy
      while(current != null)      // dopki nie koniec listy...
         {
         current.displayLink();   // ...wypisujemy dane i...
         current = current.next;  // ...przechodzimy do nastpnego elementu.
         }
      System.out.println("");
      }
// -------------------------------------------------------------
   }  // koniec klasy LinkList
////////////////////////////////////////////////////////////////
class LinkListApp
   {
   public static void main(String[] args)
      {
      LinkList theList = new LinkList();  // tworzymy now list

      theList.insertFirst(22, 2.99);      // wstawiamy cztery elementy
      theList.insertFirst(44, 4.99);
      theList.insertFirst(66, 6.99);
      theList.insertFirst(88, 8.99);

      theList.displayList();              // wypisujemy zawarto listy

      while( !theList.isEmpty() )         // dopki nie jest pusta...
         {
         Link aLink = theList.deleteFirst();   // usuwamy element z listy
         System.out.print("Usunito ");         // i wypisujemy go
         aLink.displayLink();
         System.out.println("");
         }
      theList.displayList();              // wypisujemy list ponownie
      }  // koniec main()
   }  // koniec klasy LinkListApp
////////////////////////////////////////////////////////////////
